import { Component, OnInit, Input } from '@angular/core';
import { MvpServices } from '../../../../services/mvp-services';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';

@Component({
  selector: 'app-mvp-add-mapping-validation',
  templateUrl: './mvp-add-mapping-validation.component.html',
  styleUrls: ['./mvp-add-mapping-validation.component.scss']
})
export class MvpAddMappingValidationComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
  @Input() mvpObject;
  @Input() validation;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    public mvpServices: MvpServices,
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

    getState() {
    return this.ngRedux.getState();
  }

  addValidationToMvpObject() {
    var validationInput = this.validation.trim();
    if (validationInput != null && validationInput.length > 0) {
      this.mvpObject.object = validationInput;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }
}
